package com.handheld.FingerprintDemo;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.BRMicro.Tools;
import com.handheld.Fingerprint.FingerprintManager;
import com.handheld.apiinstructions.R;

public class FingerprintActivity extends Activity {

	private ImageView mFingerprintIv;
	private Button mContinueSearchBtn;
	private Button mClearDatabaseBtn;
	private Button mInputFingerContinueBtn;
	private Button mObtainImgContinueBtn;
	private Button mOpenDeviceBtn;
	private Button mCloseDeviceBtn;
	private Button mCancelCurOperateBtn;
	private Button mQuitBtn;
	private Button button_fp_match;
	private Button button_fp_getchara;

	private TextView textView_info;
	private EditText editText_fp_1;
	private EditText editText_fp_2;
	private CheckBox checkBox_fp_1;
	private CheckBox checkBox_fp_2;

	private FingerprintManager manager;
	private SharedPreferences shp;
	private SharedPreferences.Editor shpeditor;

	private String infoString = "";
	private Bitmap bitmap;
	private Handler handler = new Handler() {
		public void handleMessage(Message msg) {
			switch (msg.what) {
			case 0:// Set buttons disabled
				setEnableBt(false);
				break;
			case 1:
				textView_info.setText(infoString);// Show hint information
				break;
			case 2:// Set buttons available
				setEnableBt(true);
				break;
			case 3:// Show fingerprint chara value
				String charaString = msg.getData().getString("chara");
				if (checkBox_fp_1.isChecked()) {
					editText_fp_1.setText(charaString);
				}
				if (checkBox_fp_2.isChecked()) {
					editText_fp_2.setText(charaString);
				}
				break;
			case 4:// Show fingerprint bitmap
				mFingerprintIv.setImageBitmap(bitmap);
				break;
			default:
				break;
			}
		};
	};
	// Show toast
	private Toast toast;

	private void showToast(String info) {
		if (toast != null) {
			toast.setText(info);
		} else {
			toast = Toast.makeText(this, info, Toast.LENGTH_SHORT);
		}
		toast.show();
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setTitle("FingerPrint-DEMO");
		setContentView(R.layout.activity_fingerprint);
		manager = new FingerprintManager();// fingerprint manager
		findViews();
		setListener();
		setEnableBt(false);
		shp = getSharedPreferences("FingerPrintNames", MODE_PRIVATE);
		shpeditor = shp.edit();
	}

	private void findViews() {
		mFingerprintIv = (ImageView) findViewById(R.id.Fingerprint_iv);
		mContinueSearchBtn = (Button) findViewById(R.id.button_fp_search);
		mClearDatabaseBtn = (Button) findViewById(R.id.button_fp_clear);
		mInputFingerContinueBtn = (Button) findViewById(R.id.button_fp_register);
		mObtainImgContinueBtn = (Button) findViewById(R.id.button_fp_getImage);
		mOpenDeviceBtn = (Button) findViewById(R.id.button_fp_open);
		mCloseDeviceBtn = (Button) findViewById(R.id.button_fp_close);
		mCancelCurOperateBtn = (Button) findViewById(R.id.button_fp_cancel);
		mQuitBtn = (Button) findViewById(R.id.button_fp_exit);
		button_fp_match = (Button) findViewById(R.id.button_fp_match);
		button_fp_getchara = (Button) findViewById(R.id.button_fp_getchara);
		textView_info = (TextView) findViewById(R.id.textview_fp_info);
		editText_fp_1 = (EditText) findViewById(R.id.editText_fg_1);
		editText_fp_2 = (EditText) findViewById(R.id.editText_fg_2);
		checkBox_fp_1 = (CheckBox) findViewById(R.id.checkBox_fp_1);
		checkBox_fp_2 = (CheckBox) findViewById(R.id.checkBox_fp_2);
	}

	private void setListener() {
		// Open device
		mOpenDeviceBtn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				textView_info.setText(R.string.now_open_device_);
				new Thread() {
					public void run() {
						handler.sendEmptyMessage(0);
						if (manager.Open(false, FingerprintActivity.this)) {
							infoString = getString(R.string.open_device_success_);
							handler.sendEmptyMessage(1);
							handler.sendEmptyMessage(2);
						} else {
							infoString = getString(R.string.open_device_fail_);
							handler.sendEmptyMessage(1);
						}
					};
				}.start();
			}
		});
		// Close device
		mCloseDeviceBtn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				// TODO Auto-generated method stub
				if (manager.Close()) {
					textView_info.setText(R.string.close_device_);
					setEnableBt(false);
					setDefaultImage(R.drawable.fp);
				}
				;
			}
		});
		// Exit
		mQuitBtn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				manager.Close();
				System.exit(0);
			}
		});
		// Match fingerprint chara 1 with fingerprint chara 2
		button_fp_match.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				final byte[] chara_1 = Tools.HexString2Bytes(editText_fp_1
						.getText().toString());
				final byte[] chara_2 = Tools.HexString2Bytes(editText_fp_2
						.getText().toString());
				if (chara_1.length > 0 && chara_2.length > 0) {
					textView_info
							.setText(R.string.now_match_fingerprint_chara_1_and_fingerprint_chara_2_);
					new Thread() {
						public void run() {
							handler.sendEmptyMessage(0);
							int socre = manager.MatchFingerprint(chara_1,
									chara_2);
							infoString = getString(R.string.match_socre_)
									+ socre;
							handler.sendEmptyMessage(1);
							handler.sendEmptyMessage(2);
						};
					}.start();

				} else {
					textView_info
							.setText(R.string.please_get_fingerprint_characteristic_first_);
				}
			}
		});
		// Get fingerprint chara
		button_fp_getchara.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				textView_info.setText(R.string.now_get_fingerprint_chara_);
				new Thread() {
					public void run() {
						handler.sendEmptyMessage(0);
//						if (!manager.DetectFinger()) {
//							infoString = getString(R.string.put_finger_on_sensor);
//						} else {

							byte[] chara = manager.GetChara();
							if (chara != null) {
								String charaString = Tools.Bytes2HexString(
										chara, chara.length);
								Message msg = new Message();
								msg.what = 3;
								Bundle bundle = new Bundle();
								bundle.putString("chara", charaString);
								msg.setData(bundle);
								handler.sendMessage(msg);
								infoString = getString(R.string.get_fingerprint_chara_success_);
							} else {
								infoString = getString(R.string.get_fingerprint_chara_fail_);
							}

//						}
						handler.sendEmptyMessage(1);
						handler.sendEmptyMessage(2);
					};
				}.start();

			}
		});
		// Get fingerprint image
		mObtainImgContinueBtn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				mFingerprintIv.setImageBitmap(null);
				textView_info.setText(R.string.get_image_now_);
				setEnableBt(false);
				new Thread() {
					public void run() {
						handler.sendEmptyMessage(0);
//						if (!manager.DetectFinger()) {
//							infoString = getString(R.string.put_finger_on_sensor);
//							handler.sendEmptyMessage(1);
//						} else {
							bitmap = manager.GetFingerprintImage();
							if (bitmap == null) {
								infoString = getString(R.string.get_image_fail_);
								handler.sendEmptyMessage(1);
							} else {
								infoString = getString(R.string.get_image_success_);
								handler.sendEmptyMessage(1);
							}
							handler.sendEmptyMessage(4);
//						}
						handler.sendEmptyMessage(2);
					};
				}.start();
			}
		});
		// Search
		mContinueSearchBtn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				textView_info
						.setText(R.string.search_this_fingerprint_chara_now_);
				setEnableBt(false);
				new Thread() {
					public void run() {
						handler.sendEmptyMessage(0);
						byte[] chara = new byte[256];
						if (checkBox_fp_1.isChecked()) {
							chara = Tools.HexString2Bytes(editText_fp_1
									.getText().toString());
						}
						if (checkBox_fp_2.isChecked()) {
							chara = Tools.HexString2Bytes(editText_fp_2
									.getText().toString());
						}
						int ret = manager.SearchFingerprint(chara);
						if (ret >= 0) {
							infoString = getString(R.string.search_success_addressid_)
									+ ret
									+ getString(R.string._name_)
									+ shp.getString(ret + "", "");
							handler.sendEmptyMessage(1);
						} else {
							infoString = getString(R.string.search_fail_);
							handler.sendEmptyMessage(1);
						}
						handler.sendEmptyMessage(2);
					};
				}.start();
			}
		});
		// Cancel operation and check free address
		mCancelCurOperateBtn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				setEnableBt(true);
				setDefaultImage(R.drawable.fp);
				editText_fp_1.setText("");
				editText_fp_2.setText("");
				int ret = manager.GetFreeAddress();
				showToast(getString(R.string.free_addressid_) + ret);
			}
		});
		// Delete all fingerprint chara
		mClearDatabaseBtn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				AlertDialog dlg = new AlertDialog.Builder(
						FingerprintActivity.this)
						.setTitle(
								R.string.sure_to_delete_all_fingerprint_chara_)
						.setPositiveButton(R.string.sure,
								new DialogInterface.OnClickListener() {
									public void onClick(DialogInterface dialog,
											int whichButton) {
										new Thread() {
											public void run() {
												handler.sendEmptyMessage(0);
												if (manager.EmptyAllChara()) {
													shpeditor.clear();
													shpeditor.commit();
													infoString = getString(R.string.clear_all_chara_success_);
												} else {
													infoString = getString(R.string.clear_all_chara_fail_);
												}
												handler.sendEmptyMessage(1);
												handler.sendEmptyMessage(2);
											};
										}.start();
									}
								})
						.setNegativeButton(R.string.cancel,
								new DialogInterface.OnClickListener() {
									public void onClick(DialogInterface dialog,
											int whichButton) {
									}
								}).create();
				dlg.show();
			}
		});
		// Input fingerprint chara to module and save (register fingerprint)
		mInputFingerContinueBtn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				final byte[] chara_1 = Tools.HexString2Bytes(editText_fp_1
						.getText().toString());
				final byte[] chara_2 = Tools.HexString2Bytes(editText_fp_2
						.getText().toString());
				if (chara_1.length == 0 || chara_2.length == 0) {
					showToast(getString(R.string.please_get_fingerprint_characteristic_first_));
					return;
				}
				new Thread() {
					public void run() {
						handler.sendEmptyMessage(0);
						int ret = manager.RegisterFingerprint(chara_1, chara_2,
								50);
						if (ret >= 0) {
							InputNameDialog(ret + "");
							infoString = getString(R.string.input_success_addressid_)
									+ ret;
						} else {
							infoString = getString(R.string.input_fail_);
							switch (ret) {
							case -1:
								infoString = infoString
										+ getString(R.string.cause_fingerprint_1_2_unmatched);
								break;
							case -2:
								infoString = infoString
										+ getString(R.string.cause_input_fail_or_already_existing_);
								break;
							default:
								break;
							}
						}
						handler.sendEmptyMessage(1);
						handler.sendEmptyMessage(2);
					};
				}.start();
			}
		});
		checkBox_fp_1.setOnCheckedChangeListener(new OnCheckedChangeListener() {

			@Override
			public void onCheckedChanged(CompoundButton arg0, boolean isChecked) {
				// TODO Auto-generated method stub
				if (isChecked) {
					checkBox_fp_2.setChecked(!isChecked);
				}
			}
		});
		checkBox_fp_2.setOnCheckedChangeListener(new OnCheckedChangeListener() {

			@Override
			public void onCheckedChanged(CompoundButton arg0, boolean isChecked) {
				// TODO Auto-generated method stub
				if (isChecked) {
					checkBox_fp_1.setChecked(!isChecked);
				}
			}
		});
	}

	@Override
	public void onDestroy() {
		super.onDestroy();
		manager.Close();
	}

	private void setEnableBt(boolean en) {
		mCancelCurOperateBtn.setEnabled(en);
//		mCloseDeviceBtn.setEnabled(en);
		mContinueSearchBtn.setEnabled(en);
		mClearDatabaseBtn.setEnabled(en);
		mInputFingerContinueBtn.setEnabled(en);
		mObtainImgContinueBtn.setEnabled(en);
		button_fp_getchara.setEnabled(en);
		button_fp_match.setEnabled(en);
	}

	public void setDefaultImage(int id) {
		mFingerprintIv.setImageResource(id);
	}

	public void setDefaultImage(String path) {
		mFingerprintIv.setImageResource(R.drawable.fp);
	}

	private void InputNameDialog(final String id) {
		runOnUiThread(new Runnable() {
			public void run() {
				LayoutInflater factory = LayoutInflater
						.from(FingerprintActivity.this);
				final View view_dialog = factory.inflate(R.layout.dialog_name,
						null);
				AlertDialog dlg = new AlertDialog.Builder(
						FingerprintActivity.this)
						.setTitle(R.string._please_input_name)
						.setView(view_dialog)
						.setPositiveButton(R.string.sure,
								new DialogInterface.OnClickListener() {
									public void onClick(DialogInterface dialog,
											int whichButton) {
										EditText edittext_name = (EditText) view_dialog
												.findViewById(R.id.edittext_fingerprint_name);
										String name = edittext_name.getText()
												.toString();
										if (!name.equals("")) {
											shpeditor.putString(id, name);
											shpeditor.commit();
										} else {
											showToast(getString(R.string._name_is_null));
											InputNameDialog(id);
										}
									}
								})
						.setNegativeButton(R.string.cancle,
								new DialogInterface.OnClickListener() {
									public void onClick(DialogInterface dialog,
											int whichButton) {

									}
								}).create();
				dlg.show();
			}
		});
	}
}
